--[[---------------------------------------------------------------------------
	Chocolatier Two: Gambling "Bonus" Game
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local char = gDialogTable.char
local started = false

local betFont = { standardFontName, kThirtyTwo, DefaultColor }

local xBonus = 60
local yBonus = 120

-------------------------------------------------------------------------------

-- Gamble minimum 1% (minimum $100) of your cash, rounded to nearest $100
local minBet = bsgFloor(gSim.money * .01)
minBet = bsgFloor((minBet + 50)/ 100) * 100
if minBet < 100 then minBet = 100
elseif minBet > 1000000 then minBet = 1000000
end

-- Gamble maximum roughly 20% of your cash, up to 50% if very low
local maxBet = bsgFloor(gSim.money * .20)
if maxBet < minBet then maxBet = gSim.money * .5 end
if maxBet > 1000000 then maxBet = 1000000 end
if maxBet < minBet then maxBet = minBet end

if minBet == maxBet and maxBet > 200 then minBet = bsgFloor(maxBet / 2) end

-- Gamble in 10 increments from min to max, increments rounded to nearest $100
local deltaBet = bsgFloor((maxBet - minBet) / 10)
if deltaBet <= 0 then
	minBet = maxBet - 1000
	if minBet < 100 then minBet = 100 end
	deltaBet = bsgFloor((maxBet - minBet) / 10)
end
deltaBet = bsgFloor((deltaBet + 50) / 100) * 100
maxBet = minBet + 10 * deltaBet

-- Allow gambling up to 50% of cash in extreme cases, with delta not necessarily rounded
if maxBet > gSim.money / 2 then
	maxBet = gSim.money / 2
	maxBet = bsgFloor(maxBet / 100) * 100
	deltaBet = bsgFloor((maxBet - minBet) / 10)
	maxBet = minBet + 10 * deltaBet
end

-- And finally, just in case the numbers are really screwy...
if maxBet < minBet then
	maxBet = minBet
	deltaBet = 0
end

local bet = minBet + 5 * deltaBet
local winnings = 0

-------------------------------------------------------------------------------

local function UpdateBet()
	SetLabel("bet", bsgDollars(bet))
	EnableWindow("bet_less", (bet > minBet))
	EnableWindow("bet_more", (bet < maxBet))
end

local function LowerBet()
	bet = bet - deltaBet
	UpdateBet()
end

local function RaiseBet()
	bet = bet + deltaBet
	UpdateBet()
end

-------------------------------------------------------------------------------

local function RevealAll()
	for i=1,25 do
		local value = SelectPrize(i,true)
		EnableWindow("select_"..tostring(i), false)
	end
end

local function Cancel()
	-- FIRSTPEEK: CratesGame, time-stamp, weeks, money, 0, 0
	if fpWrite then fpWrite { "CratesGame", gSim.weeks, gSim.money, 0, 0 } end
	
	CloseWindow()
end

local function Finish()
	SetLabel("winnings_label", GetString("you_won"))
	SetLabel("instructions", GetString("crates_welldone"))
	RevealAll()
	EnableWindow("close", true)
	EnableWindow("done", false)
end

local function Done()
	local won = winnings - bet
	
	-- FIRSTPEEK: CratesGame, time-stamp, weeks, money, bet, winnings
	if fpWrite then fpWrite { "CratesGame", gSim.weeks, gSim.money, bet, winnings } end
	
	if won == 0 then
		gSim:Message(GetString("message_tiecrates"))
		SetLabel("winnings_label", GetString("you_won", bsgDollars(bet)))
		SetLabel("winnings", bsgDollars(won))
	elseif winnings == 0 then
		gSim:Message(GetString("message_lostcrates", bsgDollars(-won)))
		SetLabel("winnings_label", GetString("you_lost"))
		local wonLabel = bsgDollars(-won)
		SetLabel("winnings", wonLabel)
	else
		gSim:AdjustMoney(winnings)
		gSim:Message(GetString("message_woncrates", bsgDollars(bet), bsgDollars(winnings)))
		SetLabel("winnings_label", GetString("you_won"))
		SetLabel("winnings", bsgDollars(won))
	end

	CloseWindow()
end

-------------------------------------------------------------------------------

local function EnableSelections(yn)
	for i=1,25 do
		EnableWindow("select_"..tostring(i), yn)
	end
end

local function AcceptBet()
	EnableWindow("start", false)
	EnableWindow("close", false)
	EnableWindow("done", true)
	SetCommand("done", Finish)
	SetLabel("done", GetString("done"))
--	EnableWindow("winnings_label", true)
--	EnableWindow("winnings_alt_label", true)
--	SetLabel("winnings", bsgDollars(winnings))

	SetLabel("winnings_label", GetString("losings"))
--	local wonLabel = WorsePriceColor .. bsgDollars(bet)
	local wonLabel = bsgDollars(0)
	SetLabel("winnings", wonLabel)
	EnableWindow("bet_more", false)
	EnableWindow("bet_less", false)
	
	gSim:AdjustMoney(-bet)
	local total = PrepareGame(bet)
	started = true

	local n = total
	if n > 100000 then n = bsgFloor(n/10000) * 10000
	elseif n > 10000 then n = bsgFloor(n/1000) * 1000
	else n = bsgFloor(n/100) * 100
	end
	SetLabel("instructions", GetString("gamble_crate_first", bsgDollars(n)))
	EnableSelections(true)
end

-------------------------------------------------------------------------------

local function DoSelect(i)
	if started then
		EnableWindow("select_"..tostring(i), false)
		local value = SelectPrize(i,false)
		if value > 0 then
			winnings = winnings + value
			local won = winnings - bet
			
--			SetLabel("winnings", bsgDollars(winnings))

--			local wonLabel = bsgDollars(won)
			local wonLabel = bsgDollars(winnings)

			if won > 0 then
				SetLabel("instructions", GetString("crates_ahead", bsgDollars(winnings), bsgDollars(bet)))
				SetLabel("winnings_label", GetString("winnings"))
			elseif won < 0 then
--				wonLabel = WorsePriceColor .. bsgDollars(winnings)
				SetLabel("instructions", GetString("crates_behind", bsgDollars(winnings), bsgDollars(bet)))
				SetLabel("winnings_label", GetString("losings"))
			else
				SetLabel("instructions", GetString("crates_even", bsgDollars(winnings), bsgDollars(bet)))
				SetLabel("winnings_label", GetString("winnings"))
			end

			SetLabel("winnings", wonLabel)
		else
			winnings = 0
--			EnableWindow("winnings_label", false)
--			EnableWindow("winnings_alt_label", false)
--			EnableWindow("winnings", false)
			SetLabel("instructions", GetString("crates_lost", bsgDollars(bet)))

			SetLabel("winnings_label", GetString("you_lost"))
			SetLabel("winnings", WorsePriceColor .. bsgDollars(bet))

			RevealAll()
			EnableWindow("close", true)
			EnableWindow("done", false)
		end
	end
end

local selections = {}
for i=1,25 do
	local n = i
	local x = bsgMod(i-1,5) * 60 + xBonus
	local y = bsgFloor((i-1)/5) * 60 + yBonus
	table.insert(selections,
		Button { x=x,y=y, w=50,h=47, graphics = {},
--			sound = "sfx/crate_click.ogg",
sound="",
			name="select_"..tostring(n), command=function() DoSelect(n) end })
end

-------------------------------------------------------------------------------

local w=600
local h=400
local charX = w - ui.charW
local buttonX = charX + (ui.charW - ui.devButtonW) / 2
local updownX = buttonX + ui.devButtonW

MakeDialog
{
	Frame
	{
		x=100+ui.xOffset,y=50+ui.yOffset,w=600,h=420,
		Text { x=5,y=5,w=w-ui.charW-5,h=ui.charH/2, name="instructions",
			label="gamble_crate_instructions", font=dialogFont, flags=kVAlignCenter+kHAlignCenter },

		Text { x=charX,y=225,w=ui.charW-24,h=20, label="your_bet", font=dialogFont },
		Text { x=charX,y=235,w=ui.charW-24,h=49, name="bet", label="#"..bsgDollars(bet), font=betFont },
		Button { x=charX+ui.charW-24,y=235, command=RaiseBet, name="bet_more",
				graphics={"control/scrollup_up", "control/scrollup_down", "control/scrollup_over"} },
		Button { x=charX+ui.charW-24,y=260, command=LowerBet, name="bet_less",
			graphics={"control/scrolldown_up", "control/scrolldown_down", "control/scrolldown_over"}, },

		Text { x=charX,y=285,w=ui.charW-24,h=20, name="winnings_label", label="", font=dialogFont },
		Text { x=charX,y=295,w=ui.charW-24,h=49, name="winnings", label="", font=betFont },
			
		TextButton { x=charX+(ui.charW - ui.devButtonW)/2,y=330, name="start", label="start", command=AcceptBet },
		TextButton { x=charX+(ui.charW - ui.devButtonW)/2,y=370, name="done", label="cancel", command=Cancel },
		TextButton { x=charX+(ui.charW - ui.devButtonW)/2,y=370, name="close", label="close", command=Done },
		
--		Text { x=charX,y=350,w=ui.charW,h=20, name="winnings", font=dialogFont },
--		Text { x=charX,y=370,w=ui.charW,h=40, name="winnings_alt_label", label="winnings_alt", font=dialogFont },
		
		BonusGame
		{
			x=0,y=0, w=kMax,h=kMax,
			Group(selections),
		},
	},
	char:Visual(ui.screenWidth-100-ui.charW+ui.xOffset, ui.yOffset, charNameFontDark),
}

UpdateBet()
EnableSelections(false)
--EnableWindow("winnings_label", false)
--EnableWindow("winnings_alt_label", false)
EnableWindow("close", false)
